/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.ParameterField;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.filter.Value2Field;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import java.util.Objects;

@FilterDescriptor(type=FilterType.SIZE)
final class SizeFilter
implements Filter {
    @Value1Field
    private final long size1;
    @Value2Field
    private final long size2;
    @ParameterField
    private final FilterParameter filterParameter;

    SizeFilter(long size1, long size2, FilterParameter filterParameter) {
        this.size1 = size1;
        this.size2 = size2;
        this.filterParameter = Objects.requireNonNull(filterParameter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size1, this.size2, this.filterParameter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SizeFilter other = (SizeFilter)obj;
        return this.filterParameter == other.filterParameter && this.size1 == other.size1 && this.size2 == other.size2;
    }

    @Override
    public boolean isFiltered(Game game, RepositoryGame repositoryGame) {
        Objects.requireNonNull(game);
        boolean filtered = false;
        switch (this.filterParameter) {
            case EQUAL: {
                filtered = game.getSize() != this.size1;
                break;
            }
            case EQUAL_OR_LESS: {
                filtered = game.getSize() > this.size1;
                break;
            }
            case EQUAL_OR_GREATER: {
                filtered = game.getSize() < this.size1;
                break;
            }
            case LESS: {
                filtered = game.getSize() >= this.size1;
                break;
            }
            case GREATER: {
                filtered = game.getSize() <= this.size1;
                break;
            }
            case BETWEEN_INCLUSIVE: {
                filtered = game.getSize() < this.size1 || game.getSize() > this.size2;
            }
        }
        return filtered;
    }
}

